/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package rdc;

import java.io.File;

import com.inet.report.AbstractFontElement;
import com.inet.report.Area;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.Paragraph;
import com.inet.report.RDC;
import com.inet.report.Section;
import com.inet.report.Text;

/**
 * This example shows how to change the font name and size of existing text fields in the Page Header section of the
 * report.
 */
public class ModifyFontOfTextFields {

    /**
     * This main method starts a new Engine, sets the report file, goes through the Page Header section and change the
     * font name and size of text fields included in the Page Header section.
     * @param argv Arguments not used in this sample
     */
    public static void main( String[] argv ) {
        try {
            // Create a new Engine
            Engine engine = new Engine( Engine.NO_EXPORT );
            // Set the name of the report file
            engine.setReportFile( "samples/rdc/ModifyFontOfTextFields.rpt" );

            // Set a new font name for text fields in Page Header section
            Area phArea = engine.getArea( "PH" );
            Section phSec = phArea.getSection( 0 );

            // All elements in the Page Header section
            Element[] elements = phSec.getElements();
            for( int i = 0; i < elements.length; i++ ) {
                Element element = elements[i];
                if( element instanceof Text ) {
                    Text text = (Text)element;
                    // All paragraphs of the text field
                    for( int j = 0; j < text.getParagraphCount(); j++ ) {
                        Paragraph paragraph = text.getParagraph( j );
                        // All text parts of the paragraph
                        for( int w = 0; w < paragraph.getPartCount(); w++ ) {
                            Element part = paragraph.getPart( w );
                            // Set a new font name for all text parts with font name "SansSerif"
                            if( part instanceof AbstractFontElement & ((AbstractFontElement)part).getFontName().equals( "SansSerif" ) ) {
                                ((AbstractFontElement)part).setFontName( "Arial" );
                                ((AbstractFontElement)part).setFontSize( 8 );
                            }
                        }
                    }
                }
            }

            // If necessary you can save the modified report in a new file.
            RDC.saveEngine( new File( System.getProperty( "user.dir" ) + "/samples/rdc/ModifiedFontOfTextFields.rpt" ), engine );
        } catch( Throwable e ) {
            e.printStackTrace();
            System.exit( 0 );
        }
    }
}
